%
% Solucion directa de las ecuaciones de diferencias finitas 
%

%% 
% Solucion directa de un problema de diferencias finitas 
clear; clc;
n = 21;
[x,y,errrel] = fd_solucion_directa(n);

%%
%  Solucion de un problema no lineal mediante diferencias finitas. 
%  Resolvemos el problema de la catenaria. Para ello, debe tenerse el 
% problema definido como un sistema de ecuaciones lineales (funcion 
% eccatenariafd).
%
clear; clc;

dh = 0.0;
L = 10.0; 
rho = 20.0;
Th   = 50.0;

xa = 0.0;
xb = L;
ya = 0.0;
yb = dh;
n = 21;

x = linspace(xa, xb, n);
y = linspace(ya, yb, n);

fcat = @(t) eccatenariafd( [ya t yb], x, rho/Th);

[x,y] = nlfd(x, y, fcat);
clf; plot(x, y,'-o');
